using System;
using System.IO;
using DynaPDF;

namespace table_templates
{
   class TableTemplates
   {
      // Error callback function.
      // If the function name should not appear at the beginning of the error message then set
      // the flag emNoFuncNames (pdf.SetErrorMode(DynaPDF.TErrMode.emNoFuncNames);).
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write("{0}\n", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		static void Main(string[] args)
		{
		   try
		   {
            CPDF pdf = new CPDF();
            // Error messages and warnings are passed to the callback function.
            pdf.SetOnErrorProc(IntPtr.Zero, new DynaPDF.TErrorProc(PDFError));
            pdf.CreateNewPDF(null); // We open the output file later if no error occurrs.

            pdf.SetPageCoords(DynaPDF.TPageCoord.pcTopDown);

            pdf.SetImportFlags2(DynaPDF.TImportFlags2.if2UseProxy); // Reduce the memory usage
            if (pdf.OpenImportFile("../../../../../dynapdf_help.pdf", DynaPDF.TPwdType.ptOpen, null) < 0)
            {
               Console.Read();
               return;
            }

            int i, rowNum, tmpl, pageCount;
            pageCount = pdf.GetInPageCount();

            CPDFTable tbl = new CPDFTable(pdf, pageCount / 4 + 1, 2, 512.12f, 0.0f);
            tbl.SetBoxProperty(-1, -1, DynaPDF.TTableBoxProperty.tbpBorderWidth, 1.0f, 1.0f, 1.0f, 1.0f);
            tbl.SetBoxProperty(-1, -1, DynaPDF.TTableBoxProperty.tbpCellPadding, 5.0f, 5.0f, 5.0f, 5.0f);
            tbl.SetGridWidth(1.0f, 1.0f);
            tbl.SetFlags(-1, -1, DynaPDF.TTableFlags.tfScaleToRect);

            pdf.SetPageFormat(DynaPDF.TPageFormat.pfUS_Letter);

            rowNum = 0;
            for (i = 1; i <= pageCount; i++)
            {
               tmpl = pdf.ImportPage(i);
               if ((i & 1) != 0) rowNum = tbl.AddRow(335.0f);
               tbl.SetCellTemplate(rowNum, (i - 1) & 1, true, DynaPDF.TCellAlign.coCenter, DynaPDF.TCellAlign.coCenter, tmpl, 0.0f, 0.0f);
            }

            // Draw the table now
            pdf.Append();
            tbl.DrawTable(50.0f, 50.0f, 742.0f);
            while (tbl.HaveMore())
            {
               pdf.EndPage();
               pdf.Append();
               tbl.DrawTable(50.0f, 50.0f, 742.0f);
            }
            pdf.EndPage();

		      TPDFError err = new TPDFError();
		      for (i = 0; i < pdf.GetErrLogMessageCount(); i++)
		      {
		         pdf.GetErrLogMessage(i, ref err);
		         Console.Write("{0}\n", err.Message);
		      }

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
   }
}
